from PyQt5 import QtWidgets

from floppyemu import format_images
from ui import format_dialog, format_one_dialog


class FormatManyDialog(QtWidgets.QDialog, format_dialog.Ui_Dialog):
    def __init__(self, device, temp_path, parent=None):
        super().__init__(parent)

        self.__device = device
        self.__temp_path = temp_path

        self.setupUi(self)

    @staticmethod
    def show_dialog(device, temp_path):
        dlg = FormatManyDialog(device, temp_path)
        dlg.exec()

    def accept(self):
        try:
            if self.rb_size_720.isChecked():
                format_images(self.__device, ((self.sb_from.value(), self.sb_to.value() + 1),), self.__temp_path, 720)
            elif self.rb_size_1440.isChecked():
                format_images(self.__device, ((self.sb_from.value(), self.sb_to.value() + 1),), self.__temp_path, 1440)
            else:
                QtWidgets.QMessageBox.critical(
                    self, 'Error',
                    'Please choose image size before proceeding'
                )
                return
        except PermissionError:
            QtWidgets.QMessageBox.critical(
                self, 'Permission error',
                'You have no access to the device %s. '
                'Please restart program as user with proper rights' % (self.__device,)
            )
            return

        super().accept()


class FormatOneDialog(QtWidgets.QDialog, format_one_dialog.Ui_Dialog):
    def __init__(self, index, device, temp_path, parent=None):
        super().__init__(parent)
        self.__index = index
        self.__device = device
        self.__temp_path = temp_path

        self.setupUi(self)

    @staticmethod
    def show_dialog(index, device, temp_path):
        dlg = FormatOneDialog(index, device, temp_path)
        dlg.exec()

    def accept(self):
        try:
            if self.rb_size_720.isChecked():
                format_images(self.__device, (self.__index, ), self.__temp_path, 720)
            elif self.rb_size_1440.isChecked():
                format_images(self.__device, (self.__index, ), self.__temp_path, 1440)
            else:
                QtWidgets.QMessageBox.critical(
                    self, 'Error',
                    'Please choose image size before proceeding'
                )
                return
        except PermissionError:
            QtWidgets.QMessageBox.critical(
                self, 'Permission error',
                'You have no access to the device %s. '
                'Please restart program as user with proper rights' % (self.__device,)
            )
            return

        super().accept()
