import subprocess
import json


def get_storage_devices(removable=None, device_type=None):
    """
    :param removable: if True return only removable devices, if False only non-removable. If None return all devices
    :param device_type: type of the devices to list
    :return: list(tuple(str, str, str))
        first tuple item is device name, second identifying string(VENDOR + MODEL), third - size
    """
    proc = subprocess.Popen(
        ['lsblk', '-dJo', 'NAME,RM,TYPE,VENDOR,MODEL,SIZE'], stdout=subprocess.PIPE, stderr=subprocess.PIPE
    )

    if proc.wait() == 0:
        result = proc.stdout.read()
        result = json.loads(result.decode('utf'))
        rval = []
        for device in result['blockdevices']:
            if removable and device['rm'] == '0':
                continue
            if removable == 'False' and device['rm'] == '1':
                continue
            if device_type is not None and device['type'] != device_type:
                continue
            rval.append((
                device['name'],
                '{} {} {}'.format(device['vendor'].strip(), device['model'].strip(), device['size']),
                device['size']
            ))

        return rval
    else:
        return []
