from PyQt5 import QtWidgets
from mount import mount
from cdemu import CDEmuException

class QDeviceMenu(QtWidgets.QMenu):
    def __init__(self, device):
        super().__init__(device.get_name())
        self._id = id
        self.load = self.addAction('Load')
        self.load.triggered.connect(self.on_load)
        self.unload = self.addAction('Unload')
        self.unload.triggered.connect(self.on_unload)
        self.addSeparator()
        self.dpm = self.addAction('DPM emulation')
        self.dpm.setCheckable(True)
        self.dpm.triggered.connect(self.on_dpm)
        self.tr = self.addAction('Transfer rate emulation')
        self.tr.setCheckable(True)
        self.tr.triggered.connect(self.on_tr)
        self.bs = self.addAction('Bad sector enulation')
        self.bs.setCheckable(True)
        self.bs.triggered.connect(self.on_bs)
        self.device = device
        self.device.add_handler('change', self.on_device_change)
        self.on_device_change()

    def on_device_change(self):
        self.unload.setEnabled(bool(self.device.get_img()))
        self.dpm.setChecked(self.device.get_dpm())
        self.tr.setChecked(self.device.get_tr())
        self.bs.setChecked(self.device.get_bs())

    def on_load(self):
        fd = QtWidgets.QFileDialog(self)
        fd.setAcceptMode(QtWidgets.QFileDialog.AcceptOpen)
        if fd.exec() == QtWidgets.QDialog.Accepted:
            self.device.load(fd.selectedFiles()[0])

    def on_unload(self):
        try:
            self.device.unload()
        except Exception as e:
            QtWidgets.QMessageBox.critical(None, 'Error', str(e))

    def on_dpm(self):
        self.device.set_dpm(self.dpm.isChecked())

    def on_tr(self):
        self.device.set_tr(self.tr.isChecked())

    def on_bs(self):
        self.device.set_bs(self.bs.isChecked())
