-- $Name: Утро принцессы Асурьи$
-- $Version: 1.0$
-- $Author: Khaelenmore Thaal$
-- $Info: Игра на Паровозик 6$

require 'fmt';
require 'noinv';
loadmod 'cutscene';
loadmod 'link';

std.phrase_show = false;

game.use = function(s)
    local anyof = {
        'Зачем?';
        'Я не хочу этого делать.';
        'Мне это не кажется хорошей идеей.';
        'Серьезно! Это просто глупо!';
        'Бессмысленно.';
        'Может не надо?';
    };
    return anyof[rnd(#anyof)];
end;

game.act = game.use;

declare {
    distances = {
    };
    MINUTE = 60;
    STEP = 25;
}

global {
    timestamp = -STEP; -- Seconds
    widget_status = 0; -- 0 -- not done; 1 -- late; 2 -- in time
    taggart_status = 0; -- 0 -- not done; 1 -- done
    boys_status = 0; -- 0 -- not done; 1 -- done
    dinner_status = 0; -- 0 -- not done; 1 -- late at all; 2 -- late 30 minutes; 3 -- a bit late; 4 -- not late
    makeup = 0; -- 0 -- not done, 1 -- done
}

function set_distance(sp, dp, di) 
    if not distances[sp] then
        distances[sp] = {};
    end;
    distances[sp][dp] = di;

    if not distances[dp] then
        distances[dp] = {};
    end;
    distances[dp][sp] = di;
end;

set_distance('bedroom', 'workshop', 15 * MINUTE);
set_distance('bedroom', 'dining_hall', 10 * MINUTE);
set_distance('bedroom', 'guard_post', 15 * MINUTE);
set_distance('bedroom', 'west_gate', 15 * MINUTE);

set_distance('workshop', 'dining_hall', 15 * MINUTE);
set_distance('workshop', 'guard_post', 20 * MINUTE);
set_distance('workshop', 'west_gate', 20 * MINUTE);

set_distance('dining_hall', 'guard_post', 20 * MINUTE);
set_distance('dining_hall', 'west_gate', 20 * MINUTE);

set_distance('guard_post', 'west_gate', 10 * MINUTE);


ppath = std.class({
    __path_type = true;
    new = function(_, t)
        if type(t) ~= 'table' then
            std.err("Wrong path argument. Use {} as path argument.", 2)
        end
        
        local n, s, sr, ds = t[1], t[2], t[3], t[4]

        if not ds then
            s, sr, ds = n, s, sr
            n = nil
        end

        local new = {
            true_disp = s;
            src = sr;
            dst = ds;
        }

        for k, v in std.pairs(t) do
            if type(k) == 'string' then
                new[k] = v
            end
        end

        new.nam = n or new.nam

        return std.room(new)
    end;
    disp = function(s)
        local w = s.dst
        if disabled(w) or closed(w) then
            return false
        end
        if s.after ~= nil and visited(w) then
            return std.call(s, 'after')
        end
        return std.call(s, 'true_disp') .. ' (' .. tostring(math.floor(distances[s.src][s.dst] / MINUTE)) ..' минут)';
    end;
    onwalk = function(s, _)
        local w = s.dst
        if not disabled(w) and not closed(w) then
            walk(w)
            if me():moved() then
                timestamp = timestamp + distances[s.src][s.dst];
            end;
        end
        return false
    end;
}, std.room)

dpath = std.class({
    __path_type = true;
    new = function(_, t)
        if type(t) ~= 'table' then
            std.err("Wrong path argument. Use {} as path argument.", 2)
        end

        local n, s, d, ds = t[1], t[2], t[3], t[4]

        if not ds then
            s, d, ds = n, s, d
            n = nil
        end

        local new = {
            true_disp = s;
            dst = ds;
            distance = d;
        }

        for k, v in std.pairs(t) do
            if type(k) == 'string' then
                new[k] = v
            end
        end

        new.nam = n or new.nam

        return std.room(new)
    end;
    disp = function(s)
        local w = s.dst
        if disabled(w) or closed(w) then
            return false
        end
        if s.after ~= nil and visited(w) then
            return std.call(s, 'after')
        end
        return std.call(s, 'true_disp') .. ' (' .. tostring(math.floor(s.distance / MINUTE)) ..' минут)';
    end;
    onwalk = function(s, _)
        local w = s.dst
        if not disabled(w) and not closed(w) then
            walk(w)
            if me():moved() then
                timestamp = timestamp + s.distance;
            end;
        end
        return false
    end;
}, std.room)

function convert_timestamp(ts)
    if ts == nil then
        ts = timestamp;
    end;

    local hours = math.floor(ts / 3600);
    local minutes = math.floor(ts / 60) - hours * 60;

    hours = hours + 6;

    if hours < 10 then
        hours = '0' .. tostring(hours);
    else
        hours = tostring(hours);
    end;

    if minutes < 10 then
        minutes = '0' .. tostring(minutes);
    else
        minutes = tostring(minutes);
    end;

    return hours .. ':' .. minutes;
end;

stat {
    nam = 'watch';
    disp = function(s)
        return convert_timestamp();
    end;
    life = function(s)
        if not here().notime then
            timestamp = timestamp + STEP;
        end;

        if here()^'guard_post' then
            if timestamp >= 5 * 60 * MINUTE then
                local taggart = lookup('#taggart')

                if taggart ~= nil then
                    remove(taggart, here());
                    _'#guard':enable();
                    
                    pr [[К Таггарту подходит незнакомый мне стражник и что-то говорит ему. После этого Таггарт направляется к выходу. Проходя мимо меня, он с укоризной смотрит мне в лицо и ничего не говоря удаляется. Сейчас передавать ему ключ не только бесполезно, но и может навредить. ]];
                end;
            end;
        elseif here()^'dining_hall' then
            if timestamp >= 6 * 60 * MINUTE then
                dinner_status = 4;
                walkin('ending1');
            end;
        elseif here()^'workshop' then
            if timestamp > 180 * MINUTE and lookup('#widget', here()) then
                remove(lookup('#widget', here()), here());
                pr [[Виджет уходит из мастерской. К счастью, он не замечает меня. ]];
            end;
        end;
    end;
}

menu {
    nam = 'task_list';
    disp = 'Список дел';
    inv = function(s)
        if dinner_status == 0 then
            pn [[12:00 -- званый обед. Нужно одеться в праздничное платье и привести себя в порядок. ]];
        else
            pn(fmt.st([[12:00 -- званый обед. Нужно одеться в праздничное платье и привести себя в порядок. ]]));
        end;

        if boys_status == 0 then
            pn [[До обеда мне нужно принести Уиллу и Фреду какую-нибудь безделушку, чтобы они могли оплатить билеты в цирк. От западных ворот до места встречи -- около 40 минут. ]];
        else
            pn(fmt.st([[До обеда мне нужно принести Уиллу и Фреду какую-нибудь безделушку, чтобы они могли оплатить билеты в цирк. От западных ворот до места встречи -- около 40 минут. ]]));
        end;

        if widget_status == 0 then
            pn [[6:30 -- 9:00 -- Виджет ждет меня в мастерской. Мне нужно найти блокнот с моими заметками. Мне нужно минимум полчаса, так что позже 8:30 приходить не стоит. ]];
        else
            pn(fmt.st([[6:30 -- 9:00 -- Виджет ждет меня в мастерской. Мне нужно найти блокнот с моими заметками. ]]));
        end;

        if taggart_status == 0 then
            pn [[До 11:00 -- Вернуть ключ от склада Таггарту. ]];
        else
            pn(fmt.st([[До 11:00 -- Вернуть ключ от склада Таггарту. ]]));
        end;
    end;
}

room {
    nam = 'main';
    disp = 'Истории Тайрандела: Утро принцессы Асурьи';
    noinv = true;
    notime = true;
    decor = [[
        Мое имя Асурья, но друзья зовут меня Асти. Я дочь Данасиса I, императора Тайрандела, и законная наследница трона.
        Сегодня у меня очень важный день -- папа устраивает званый обед в честь годовщины освобождения Далагара от злых чар.
        Но это не единственное, что у меня запланировано на сегодня.
    ]];
    way = {
        path {'Начать игру', 'bedroom'};
        path {'Вступление', 'intro1'};
        path {'Об игре', 'about'};
    };
}

room {
    nam = 'about';
    noinv = true;
    notime = true;
    disp = 'Истории Тайрандела: Утро принцессы Асурьи';
    decor = fmt.b('Идея и реализация: ^') ..
        'Khaelenmore Thaal^^' ..
        fmt.b('Движок: ^') ..
        'INSTEAD, Петр Косых ({$link https://instead3.syscall.ru/})^^' ..
        fmt.b('Тестирование: ^') ..
        'Lucky Ook, Mystery Shopper, Sabra Naikomy, Артур А., Борис Тимофеев^^' ..
        fmt.b('Лицензия:^') ..
        'CC BY SA ({$link http://creativecommons.org/licenses/by-sa/4.0/})^^' ..
        fmt.b('Официальный сайт: ^') .. 
        '{$link http://silverwing.one/}';
    way = {
        path {'Начать игру', 'bedroom'};
        path {'Вступление', 'intro1'};
        path {'Назад', 'main'};
    };
}

cutscene {
    nam = 'intro1';
    disp = 'Утро принцессы Асурьи';
    noinv = true;
    notime = true;
    decor = function(s)
        pr [[
            [cut Тихий переливчатый звон]Тихий переливчатый звон со стороны камина возвестил начало нового дня. Я уже давно не прибегаю к помощи слуг по утрам -- они больше мешают, чем помогают. ^
            [cut Я поднимаюсь с кровати]Я поднимаюсь с кровати и сладко потягиваюсь. Часы показывают ровно 6 часов утра. ^
            [cut Пора вспомнить мои планы на сегодня][code walk('intro2')]
        ]];
    end;
}

cutscene {
    nam = 'intro2';
    disp = 'Накануне вечером...';
    noinv = true;
    notime = true;
    decor = function(s)
        pr [[
            Я вытаскиваю из кармашка своего походного костюма [cut маленькие изящные часики]маленькие изящные часики -- подарок Виджета на мой двенадцатый день рождения. Короткая стрелка почти достигла цифры семь. ^
            [cut Пора возвращаться домой]Пора возвращаться домой.^
            "Ребята, мне пора!" -- Кричу я. В ответ доносится: "До завтра, Асти!"^
            [cut Я делаю несколько шагов]Я делаю несколько шагов, как вдруг замечаю сидящего неподалеку и грустно смотрящего куда-то вдаль Уилла.^
            [cut "Что случилось?"]"Что случилось?" -- спрашиваю я, свалившись в траву рядом с другом. ^
            "Цирк завтра уезжает, а я так и не смог скопить денег, чтобы сходить туда с Фредом", -- грустно сообщает он.  ^
            [cut "Я помогу вам..."]"Я помогу вам. Завтра ждите меня здесь с утра. Я принесу вам что-нибудь ценное, чтобы вы смогли купить билеты", -- обещаю я. Уилл сразу меняется в лице: "Я даже не знаю, как благодарить тебя. По тебе вообще не скажешь, что ты из этих, богатых..."^
            "Иногда в этом есть свои преимущества", -- отвечаю я и, попрощавшись с Уиллом, убегаю домой.^
            [cut Продолжить]
            [code walk('intro3')]
        ]];
    end;
}

cutscene {
    nam = 'intro3';
    disp = 'Накануне днем...';
    noinv = true;
    notime = true;
    decor = function(s)
        pr [[
            Гремлин стоял передо мной, пытаясь отдышаться -- он с трудом догнал меня, спешащую в библиотеку. ^
            [cut "Ваше высочество!.."]"Ваше высочество! Вы просили сообщить!" -- выпалил Виджет, после чего продолжил обильно глотать воздух -- бедняга совсем запыхался.  ^
            [cut "Виджет, успокойся..."]"Виджет, успокойся, отдышись и расскажи все как следует", -- медленно говорю я, пытаясь успокоить друга.^
            Отдышавшись он продолжает: _"Асти, я могу подготовить для тебя мастерскую. [cut Завтра..."_]Завтра, с половины седьмого до девяти. Успеешь?"_^
            "Успею, не переживай", -- отвечаю я. Виджет убегает по своим делам, а я направляюсь дальше в библиотеку. ^
            [cut Продолжить]
            [code walk('intro4')]
        ]];
    end;
}

cutscene {
    nam = 'intro4';
    disp = 'Накануне утром...';
    noinv = true;
    notime = true;
    decor = function(s)
        pr [[
            [cut "Вот, держи..."]"Вот, держи. Только, пожалуйста, верни мне его завтра до 11 часов, иначе у меня будут большие проблемы", -- прошептал Таггарт, протягивая мне [cut небольшой сверточек]небольшой сверточек. В сверточке был ключ от одной из неиспользуемых кладовых дворца. Там я устроила [cut алхимическую лабораторию]алхимическую лабораторию для себя. Если родители прознают про нее, мне конец -- родители запрещают мне заниматься алхимией.^
            "Да, как и всегда. Спасибо, Таггарт", -- отвечаю я, [cut пряча сверток в карман куртки]пряча сверток в карман куртки. "Ладно, я побегу, до новых встреч", -- прощаюсь я и убегаю.^
            [cut Продолжить]
            [code walk('intro5')]
        ]];
    end;
}


cutscene {
    nam = 'intro5';
    disp = 'Накануне перед сном...';
    noinv = true;
    notime = true;
    decor = function(s)
        pr [[
            Я вхожу в кабинет отца. Он молча указывает на кресло, стоящее в углу, рядом с камином. Я сажусь и [cut жду]жду. ^
            Через несколько минут он встает напротив меня и начинает, как всегда многословно, [cut излагать]излагать: _"Асурья, дочь моя. Как ты знаешь, завтра у нас очень важный день, а именно -- годовщина изгнания древнего зла из славного города [cut Далагара..."_]Далагара..."_^
            Так он продолжает довольно долго, но главное. что я уяснила -- завтра, в 12 часов мне необходимо явиться в главный обеденный зал дворца.^
            [cut Продолжить]
            [code walk('intro6')]
        ]];
    end;
}

cutscene {
    nam = 'intro6';
    disp = 'Утро принцессы Асурьи';
    noinv = true;
    notime = true;
    decor = function(s)
        pr [[
            [cut Итак...]
            В 12 часов дня у меня званый обед. Если я опоздаю, папа будет очень недоволен. Мне обязательно нужно одеться, сделать макияж и уложить волосы к этому времени.^
            [cut Далее...]
            Я обещала Уиллу принести какую-нибудь ценную безделушку, чтобы они с братом могли оплатить билеты в цирк. Мы собирались встретиться [cut на опушке леса]на опушке леса. От западных ворот я доберусь туда за 40 минут.^
            [cut Кроме того...]
            C 6:30 до 9:00 Виджет ждет меня в мастерской. Мне нужно не забыть взять свои записи. Виджету непросто выделять для меня мастерскую, [cut поэтому]поэтому лучше сильно не опаздывать. И заниматься менее получаса не имеет смысла, так что приходить после 8:30 нет смысла.  ^
            [cut И наконец...]
            До 11:00 мне нужно успеть вернуть Таггарту ключ, иначе у него будут проблемы.^
            [cut Продолжить]
            [code walk('bedroom')]
        ]];
    end;
}

obj {
    nam = 'trinket';
    disp = 'Колечко';
    inv = 'Серебряное колечко с резным узором в виде чешуи. Такие встречаются довольно часто, но при этом достаточно ценные. ';
}

obj {
    nam = 'notebook';
    disp = 'Записная книжка';
    dsc = 'Из-под кровати торчит уголок {блокнота}. ';
    tak = 'Я подбираю блокнот. Хорошо, что слуги не забрали его ночью. ';
    inv = 'Здесь я держу заметки по поводу различных механизмов придуманных мной, или показанных мне Флинном и Виджетом. ';
}:disable();

obj {
    nam = 'key';
    disp = 'Ключ';
    inv = 'Ключ от склада. Я договорилась с Таггартом, чтобы забрать оттуда несколько очень нужных мне вещичек. Теперь мне надо вернуть его. ';
}

room {
    nam = 'bedroom';
    disp = 'Спальня';
    dsc = 'Моя спальня. Здесь я сплю и иногда читаю. ';
    way = {
        ppath {'В мастерскую', 'bedroom', 'workshop'};
        ppath {'В обеденный зал', 'bedroom', 'dining_hall'};
        ppath {'К сторожевому посту', 'bedroom', 'guard_post'};
        ppath {'К западным воротам', 'bedroom', 'west_gate'};
    };
}: with {
    obj {
        state = 0;
        nam = '#bed';
        dsc = 'В центре комнаты стоит {моя кровать}. ';
        act = function(s)
            pr 'Большая, удобная кровать. Изящные резные ножки и изголовье покрыты позолотой. Спать хочется, но нельзя -- впереди много дел. ';
            if s.state == 0 then
                s.state = 1;
                _'notebook':enable();
                pr 'Под кроватью я замечаю что-то белое. Да это же мой блокнот!';
            end;
        end;
    }:  with {
        'notebook';
    };
    obj {
        nam = '#fireplace';
        dsc = 'В стене расположен {камин}. ';
        act = 'Камин облицован красным кирпичом. Сейчас он не горит -- и без того жарко. Внутри лежат несколько поленьев. Мне нравится смотреть на огонь долгими зимними вечерами. ';
    };
    obj {
        nam = '#clock';
        dsc = 'Над камином висят {часы}.';
        act = function(s)
            return 'Старинные! Я взяла их у мамы. Они не работали, но я починила их сама. Это был один из тех немногих случаев, когда мне позволили хоть что-то сделать своими руками! Часы показывают ' .. convert_timestamp(timestamp + STEP) .. '. ';
        end;
    };
    obj {
        nam = '#wardrobe';
        dsc = 'В углу комнаты стоит {шкаф с моей одеждой}.';
        act = function(s)
            walkin('wardrobe');
        end;
    };
    obj {
        nam = '#table';
        dsc = 'Рядом со шкафом стоит небольшой {столик}. ';
        act = function(s)
            return walkin('table');
        end;
    };
}

room {
    nam = 'table';
    disp = 'Столик';
    dsc = 'Мой туалетный столик. Здесь я привожу себя в порядок, когда это необходимо. ';
    way = {
        path {'Назад', function(s) return here():from() end; };
    }
}: with {
    obj {
        nam = '#mirror';
        dsc = 'На столе стоит {зеркальце}. ';
        act = function(s)
            if makeup == 0 then
                return 'Здесь я могу {#makeup|привести себя в порядок} перед обедом. Это займет 30 минут. И лучше сделать это после всех остальных дел, чтобы не испортить макияж и прическу. ';
            else
                return 'Мне некогда с этим больше возиться. ';
            end;
        end;
    };
    obj {
        nam = '#makeup';
        act = function(s)
            if makeup == 0 then
                if have('clothes_dress') then
                    makeup = 1;
                    timestamp = timestamp + 30 * MINUTE;
                    return 'Я привожу в порядок свои волосы и лицо. Теперь я выгляжу достаточно "прилично" по меркам двора. ';
                else
                    return 'Сперва надо одеться как подобает. ';
                end;
            else
                return 'Я уже сделала все, что нужно. ';
            end;
        end;
    };
    obj {
        state = 0;
        nam = '#jewelbox';
        dsc = 'Перед зеркалом стоит {шкатулка}. ';
        act = function(s)
            if s.state == 0 then
                s.state = 1;
                take('trinket');
                return 'В ней хранятся мои драгоценности. Посмотрим, что отсюда можно отдать друзьям. Вот это колечко подойдет. Я забираю из шкатулки серебряное колечко. ';
            else
                return 'Мне некогда перебирать безделушки. ';
            end;
        end;
    };
}

dlg {
    nam = 'wardrobe';
    disp = 'Шкаф';
    dsc = [[
        Шкаф с моей одеждой. Будь моя воля -- выкинула бы все кроме пары лабораторных халатов, 
        рабочей одежды механика и моего походного костюма. 
        Но все остальные думают иначе. А разбираться с этим хламом мне. 
        Хорошо хоть поняли, что я умею одеваться самостоятельно и больше не кружат вокруг меня по утрам, словно назойливые мухи! ^
        Оденусь я за десять минут. Осталось решить, что же мне надеть? 
    ]];
    phr = {
        {cond=function(s) return not have('clothes_dress') end, 'Праздничное платье. Терпеть их не могу, но папа обидится, если я не надену его на сегодняшний обед. ', function(s)
            remove('clothes_mech', me());
            remove('clothes_travel', me());
            take('clothes_dress');
            timestamp = timestamp + 10 * MINUTE;
            walkout();
            return 'Я переодеваюсь. ';
        end};
        {cond=function(s) return not have('clothes_mech') end, 'Робу механика. В ней удобно работать в мастерской. ', function(s)
            remove('clothes_dress', me());
            remove('clothes_travel', me());
            take('clothes_mech');
            timestamp = timestamp + 10 * MINUTE;
            walkout();
            if makeup == 1 then
                makeup = 0;
                return 'Пока переодевалась, я испортила прическу и макияж. Придется делать все заново. ';
            else
                return 'Я переодеваюсь. ';
            end;
        end};
        {cond=function(s) return not have('clothes_travel') end, 'Походная одежда. Припрятана под шкафом. В ней меня узнают только друзья и родственники. ', function(s)
            remove('clothes_mech', me());
            remove('clothes_dress', me());
            take('clothes_travel');
            timestamp = timestamp + 10 * MINUTE;
            walkout();
            if makeup == 1 then
                makeup = 0;
                return 'Пока переодевалась, я испортила прическу и макияж. Придется делать все заново. ';
            else
                if _'clothes_travel'.state == 0 then
                    return 'Я переодеваюсь. Кажется, в одном из карманов что-то есть. ';
                else
                    return 'Я переодеваюсь. ';
                end;
            end;
        end};
        {cond=function(s) return have('clothes_dress') or have('clothes_mech') or have('clothes_travel') end, 'Не переодеваться', function(s)
            walkout();
            return 'Я отошла от шкафа. ';
        end;};
    };
}

obj {
    nam = 'clothes_dress';
    disp = 'Платье';
    inv = 'Оно красивое. Нет, правда. Оно действительно красивое. Все эти кружева, оборочки и прочие рюшечки! А эти восхитительные цветочки, вышитые серебряными и золотыми нитями! Но до чего же оно неудобное -- приходится следить за каждым шагом, чтобы ни за что не зацепиться и не повредить его! Кому вообще в голову пришло шить такие непрактичные вещи?!';
}

obj {
    state = 0;
    nam = 'clothes_mech';
    disp = 'Костюм механика';
    inv = 'Удобный и очень практичный костюм из грубой, плотной и очень прочной ткани на заказ. Сшит специально для меня и сидит как влитой. А сколько же в нем карманов, не счесть! Обожаю карманы. В них можно носить всякие вещицы вроде блокнотов, карандашей, отверточек или деталюшек -- никогда не знаешь, для чего они пригодятся.';
}

obj {
    state = 0;
    nam = 'clothes_travel';
    disp = 'Походная одежда';
    inv = function(s)
        pr 'Практичный и прочный костюм. Высокие кожаные башмаки, толстые брюки из плотной ткани, названия которой я не знаю, куртка с капюшоном из такой же. Он немного велик мне, но все равно нравится мне. Здесь не так много карманов, как в моем рабочем костюме, но зато он похож на одежду, которую носят слуги, часто покидающие дворец, а в капюшоне меня не узнать. ';
        if s.state == 0 then
            s.state = 1;
            pr '^В одном из карманов я нахожу ключик. ';
            take('key');
        end;
    end;
}

room {
    nam = 'workshop';
    disp = 'Мастерская';
    onenter = function(s)
        if have('clothes_dress', me()) then
            pr 'Я не смогу в этом работать! Надо надеть что-нибудь нормальное. ';
            return false;
        end;
        if have('clothes_travel', me()) then
            pr 'В этой одежде здесь лучше не появляться. Многие механики меня знают в лицо. Кто-нибудь может проболтаться моим родителям про этот костюм и тогда у меня будут проблемы.';
            return false;
        end;
        if not have('clothes_travel', me()) and not have('clothes_mech', me()) then
            pr 'Не пойду я никуда пока не оденусь!';
            return false;
        end;
        if (timestamp > 180 * MINUTE) and lookup('#widget', s) then
            remove(lookup('#widget', s), s);
            pr 'Ну вот, я опоздала! Виджет уже ушел. ';
        end;
    end;
    dsc = 'Мастерская механиков. Здесь работают мои друзья Флинн и Виджет. ';
    way = {
        ppath {'В спальню', 'workshop', 'bedroom'};
        ppath {'В обеденный зал', 'workshop', 'dining_hall'};
        ppath {'К сторожевому посту', 'workshop', 'guard_post'};
        ppath {'К западным воротам', 'workshop', 'west_gate'};
    };
}:with {
    obj {
        nam = '#workbenches';
        dsc = 'Вдоль стен расставлены {верстаки}. ';
        act = 'Рабочие места наших механиков. Надо спросить у Виджета, где я могу позаниматься сегодня. ';
    }: with {
        obj {
            nam = '#workers';
            dsc = 'У некоторых из них стоят {рабочие}.';
            act = 'Одни собирают какие-то механизмы, другие вытачивают детали, третьи корпят над чертежами. Не стоит им мешать. ';
        };
        obj {
            nam = '#widget';
            dsc = 'За одним из верстаков работает {Виджет}. ';
            act = function(s)
                walkin('widget_dlg');
            end;
        }
    };
    obj {
        nam = '#machinery';
        dsc = 'В зале установлено несколько {станков}.';
        act = 'Виджет не разрешает мне на них работать. Говорит, что это опасно, и я могу пораниться. ';
    };
}

dlg {
    nam = 'widget_dlg';
    disp = 'Виджет';
    noinv = true;
    notime = true;
    enter = [[Гремлин увлеченно собирает какой-то механизм. Виджет всегда уходит с головой в свои занятия, так что приходится его отвлекать. Но он никогда не обижается на меня, так что все нормально. ]];
    phr = {
        {'Виджет! Я пришла!', function(s)
            if timestamp >= 150 * MINUTE then
                walkout();
                return 'Виджет отвлекается от своих занятий и приветствует меня: "Асти! Несносная девчонка! Ты на часы смотрела? Приходи, в следующий раз". Мастер возвращается к своим делам. ';
            else
                return 'Виджет отвлекается от своих занятий и радушно приветствует меня: "Ваше высочество! Вы взяли ваши записи?"';
            end;
        end,
            {cond=function(s) return have('notebook', me()); end, '[Достать записную книжку из кармана] Да, они при мне.', function(s) 
                remove('notebook', me());
                walk('widgets_lesson');
            end};
            {'[Уйти] Забыла... И я не смогу без них ничего сделать.', function(s) walkout(); end};
        };
        {'[Уйти]', function(s) walkout(); end};
    };
}

cutscene {
    nam = 'widgets_lesson';
    disp = 'Мастерская';
    noinv = true;
    notime = true;
    decor = function(s)
        local intime = timestamp < 60 * MINUTE;
        local duration = 120 * MINUTE;

        if timestamp < 30 * MINUTE then
            timestamp = 30 * MINUTE;
        end;

        if intime then
            widget_status = 2;
            pr [[
                "Тогда за работу, Асти!" -- отвечает гремлин, указывая мне на заботливо подготовленный верстак, и тут же осекся: "Простите, Ваше высочество". ^
                [cut "Все в порядке, Виджет..."]
                "Все в порядке, Виджет, спасибо" -- благодарю я мастера и подхожу к рабочему месту. ^
            ]];
        else
            widget_status = 1;
            pr [[
                "Асти, ты слегка опоздала, поэтому, проследи за временем, договорились?", -- отвечает гремлин, указывая мне на заботливо подготовленный верстак, и тут же осекся: "Простите, Ваше высочество".  ^
                [cut "Разумеется, я закончу вовремя..."]
                "Разумеется, я закончу вовремя, спасибо, Виджет", -- благодарю я мастера и подхожу к рабочему месту. ^
            ]];
        end;

        pr [[
            [cut Я открываю записную книжку]
            Я открываю записную книжку на нужной странице и начинаю вспоминать, какие детали мне понадобятся. ^
            [cut Вырвав лист из книжки]
            Вырвав лист из книжки, я выписываю на него список необходимых деталей и передаю его гремлину: "Собери, пожалуйста, вот это. Я все-таки хочу собрать этот счетчик".
            Виджет, откланявшись, [cut удаляется]удаляется, а я погружаюсь в процесс. Вернувшись с коробочкой, полной разнообразных деталюшек, 
            он спрашивает: _"Асти, мне кажется оно не будет работа... [cut Ой, простите!.."_]Ой, простите! Ваше высочество точно уверены, что хотят собрать этот прибор? Если честно, я не уверен, что он будет работать"_. ^
            [cut "Вы сомневаетесь в моих способностях?"]
            "Ты сомневаешься в моих способностях?" -- шутливо спрашиваю я, на что Виджет совершенно серьезно отвечает: "Нет-нет, ни в коем разе! Я буду поблизости, если понадоблюсь вашему высочеству". ^
            [cut И я погрузилась в работу]И я погрузилась в работу.^
        ]];

        timestamp = timestamp + duration;
        remove(lookup('#widget', 'workshop'), 'workshop');

        if intime then
            pr [[
                Я успешно собираю работающий механизм и бегу показать его Виджету. Мастер, кажется, доволен моей работой, хотя и 
                [cut не удерживается от скептического комментария]
                не удерживается от скептического комментария: "Асти, при всем уважении -- не вижу смысла в этой штуковине. Я не понимаю, как она будет работать".^
                [cut Я слегка улыбаюсь]
                Я слегка улыбаюсь гремлину и прощаюсь с ним и другими мастерами. Виджет уходит по своим делам, а меня ждут мои.
            ]];
        else
            pr [[
                Я успешно собираю работающий механизм и бегу показать его Виджету. Мастер кажется
                [cut немного взволнован]
                немного взволнован: "Ваше высочество отлично справились, пусть и немного не вовремя".^
                [cut "Прости, Виджет"]
                "Прости, Виджет", -- произношу я смущенно, но гремлин уже ушел по своим делам. Что же, пора и мне заняться моими.^
            ]];
        end;

        pr '[cut Продолжить]'
        pr '[code walk("workshop");]'
    end;
}

room {
    nam = 'dining_hall';
    disp = 'Обеденный зал';
    dsc = 'Большой обеденный зал. Тут папа устраивает званые обеды и ужины. ';
    onenter = function(s)
        if have('clothes_travel', me()) then
            pr 'Там много близких мне людей. Если они узнают меня, у меня будут проблемы!';
            return false;
        end;
        if have('clothes_mech', me()) then
            pr 'Увы, но приходить на обед придется именно в праздничном платье и никак иначе. ';
            return false;
        end;
        if makeup == 0 then
            pr 'Появляться на обеде с неуложенными волосами и ненакрашенным лицом будет по меньшей мере опрометчиво. ';
            return false;
        end;
        if not have('clothes_dress', me()) and not have('clothes_mech', me()) then
            pr 'Не пойду я никуда пока не оденусь!';
            return false;
        end;
    end;
    enter = function(s)
        if timestamp > 6 * 60 * MINUTE then
            if timestamp > 8 * 60 * MINUTE then
                dinner_status = 1;
            elseif timestamp > (6 * 60 + 30) * MINUTE then
                dinner_status = 2;
            else
                dinner_status = 3;
            end;
            walkin('ending1');
        end;
    end;
    way = {
        ppath {'В спальню', 'dining_hall', 'bedroom'};
        ppath {'В мастерскую', 'dining_hall', 'workshop'};
        ppath {'К сторожевому посту', 'dining_hall', 'guard_post'};
        ppath {'К западным воротам', 'dining_hall', 'west_gate'};
    };
}: with {
    obj {
        nam = '#tables';
        dsc = 'По всему залу аккуратно расставлены огромные {столы}. ';
        act = 'Громадные столы из редкой породы дерева. Поверхности столов полированы и закрыты расшитыми золотыми и серебряными цветочками белоснежными скатертями. За каждым из таких можно уместить не меньше сотни человек!';
    };
    obj {
        nam = '#servants';
        dsc = 'По залу туда сюда бегают {слуги}. ';
        act = 'Они заняты подготовкой зала к сегодняшнему празднеству. Не стоит их отвлекать. ';
    };
    obj {
        nam = '#chandeliers';
        dsc = 'Над столами висят огромные богато-украшенные {люстры}. ';
        act = 'Дворец оснащен по последнему слову техники, поэтому освещение у нас электрическое. Виджет объяснял мне как работают лампочки -- в вакуумной колбочке протянута металлическая нить, которая при прохождении тока раскаляется и начинает светить. Я очень хочу попробовать собрать что-нибудь электрическое!';
    };
    obj {
        nam = '#wait';
        dsc = 'Я могу {подождать обеда} здесь. ';
        act = function(s)
            dinner_status = 4;
            walkin('ending1');
        end;
    };
}

room {
    nam = 'guard_post';
    disp = 'Сторожевой пост';
    onenter = function(s)
        if have('clothes_dress', me()) or have('clothes_mech', me()) then
            pr 'Я не хочу, чтобы меня там видели. У меня есть походная одежда, в которой меня не узнать, лучше одеться в нее. ';
            return false;
        end;
        if not have('clothes_travel') then
            pr 'Не пойду я никуда пока не оденусь!';
            return false;
        end;
        
        if timestamp > 5 * 60 * MINUTE then
            local taggart = lookup('#taggart', 'guard_post');
            if taggart ~= nil then
                remove(taggart, 'guard_post');
                lookup('#guard', 'guard_post'):enable();
                p [[Я опоздала. Таггарт уже ушел. Чтоб меня теневики забрали! Что же теперь с ним будет...]];
            end;
        end;
    end;
    enter = function(s)
        if taggart_status == 0 and timestamp <= 5 * 60 * MINUTE then
            walkin('taggart_dlg');
        end;
    end;
    dsc = 'Сторожевой пост у главной кладовой. Попасть туда можно только через него. ';
    way = {
        ppath {'В спальню', 'guard_post', 'bedroom'};
        ppath {'В мастерскую', 'guard_post', 'workshop'};
        ppath {'В обеденный зал', 'guard_post', 'dining_hall'};
        ppath {'К западным воротам', 'guard_post', 'west_gate'};
    };
}: with {
    obj {
        nam = '#door';
        dsc = 'Небольшая, но массивная и прочная {дверь} ведет в кладовую. ';
        act = 'Это главная кладовая дворца, там мы храним практически все непродовольственные запасы -- бумагу, ткани, одежду, топливо, детали для мастерских, реагенты для алхимиков и многое другое. ';
    };
    obj {
        nam = '#table';
        dsc = 'У одной из стен стоит массивный дубовый {стол}. ';
        act = 'Устойчивый. Поверхность не очень ровная, правда. За таким я бы не смогла ни рисовать ни писать. Неужели нельзя было поставить нормальный?';
    }: with {
        obj {
            nam = '#chair';
            dsc = 'За столом стоит не менее массивный {стул}. ';
            act = 'Я как-то пробовала сидеть на таком. Спина начинает болеть уже через несколько минут! Зато он прочный и устойчивый -- даже качаться можно, не сломается. Не в пример нашим. ';
        }: with {
            obj {
                nam = '#taggart';
                dsc = 'На стуле сидит {Таггарт}.';
                act = function(s)
                    if taggart_status == 0 then
                        walkin('taggart_dlg');
                    else
                        return [[Я уже отдала ему ключ. Не стоит больше отвлекать его. ]];
                    end;
                end;
            };
            obj {
                nam = '#guard';
                dsc = 'На стуле сидит {Стражник}.';
                act = 'Не стоит его беспокоить. ';
            }:disable();
        }
    }
}

dlg {
    nam = 'taggart_dlg';
    disp = 'Таггарт';
    noinv = true;
    notime = true;
    enter = [[Таггарт чуть старше меня, и он мой хороший друг. Увидев меня, он подходит и спрашивает тихо: "Асти? Ты принесла?"]];
    phr = {
        {cond=function(s) return have('key'); end, "[Отдать ключ] Да, конечно. ", function(s)
            taggart_status = 1;
            remove('key');
            walkout();
            return [["Спасибо, Асти. Я знал, что ты не подведешь", -- с улыбкой отвечает Таггарт.]]
        end};
        {"[Уйти] Ой, забыла.", function(s)
            walkout();
            return [["Асти! Мне очень сильно попадет, если ты не принесешь ключ. Моя смена заканчивается ровно в 11. Если я не сдам его, меня накажут", -- ругается Таггарт. И я его прекрасно понимаю. Не мешкая, я убегаю искать ключ. ]]
        end};
    };
}

room {
    nam = 'west_gate';
    disp = 'Западные ворота дворца';
    dsc = 'Западные ворота дворца. Через них мне проще всего будет добраться до места встречи с Фредом и Уиллом. ';
    onenter = function(s)
        if have('clothes_dress', me()) or have('clothes_mech', me()) then
            pr 'Я не хочу, чтобы меня там видели. У меня есть походная одежда, в которой меня не узнать, лучше одеться в нее. ';
            return false;
        end;
        if not have('clothes_travel') then
            pr 'Не пойду я никуда пока не оденусь!';
            return false;
        end;
    end;
    way = {
        ppath {'В спальню', 'west_gate', 'bedroom'};
        ppath {'В мастерскую', 'west_gate', 'workshop'};
        ppath {'В обеденный зал', 'west_gate', 'dining_hall'};
        ppath {'К сторожевому посту', 'west_gate', 'guard_post'};
        path {'Выйти', 'west_gate_outside'};
    };
}: with {
    obj {
        nam = '#guards';
        dsc = 'У ворот стоят двое {стражников}. ';
        act = 'Демон! Одного из них я знаю. Это Игерд. Он меня ни за что не пропустит если узнает. Но в этой одежде он меня не узнает. ';
    };
    obj {
        nam = '#gate';
        dsc = '{Ворота} открыты. ';
        act = 'Здесь постоянно ходят слуги, так что на меня никто не обратит внимания. ';
    };
    obj {
        nam = '#servants';
        dsc = 'Время от времени кто-то из {слуг} входит или выходит из дворца. ';
        act = 'Издалека меня я очень похожа на них. Надеюсь, смогу пройти незамеченной. ';
    };
    obj {
        nam = '#boxes';
        dsc = 'Неподалеку от ворот составлены какие-то {ящики}. ';
        act = 'В ящиках хранятся различные припасы, привозимые во дворец. Отсюда их забирают наши слуги и разносят по кладовым. ';
    };
}

room {
    nam = 'west_gate_outside';
    disp = 'Снаружи западных ворот';
    dsc = 'Я выбралась за пределы дворца. Отсюда я за сорок минут доберусь до леса, где я договорилась встретиться с Фредом и Уиллом. ';
    way = {
        path {'Во дворец', 'west_gate'};
        dpath {'В лес', 40 * MINUTE, 'forest'};
    }
}: with {
    obj {
        nam = '#gate';
        dsc = '{Ворота} открыты. ';
        act = 'Здесь постоянно ходят слуги, так что я могу пройти незамеченной. ';
    };
    obj {
        nam = '#servants';
        dsc = 'Время от времени кто-то из {слуг} входит или выходит из дворца. ';
        act = 'Издалека меня я очень похожа на них. Надеюсь, смогу пройти незамеченной. ';
    };
    obj {
        nam = '#guards';
        dsc = 'У ворот стоят двое {стражников}.';
        act = 'Двое снаружи и двое внутри, как и всегда. Этих двоих я не знаю. ';
    };
}

room {
    nam = 'forest';
    disp = 'Опушка леса';
    dsc = 'Я стою на опушке леса. Дышится здесь легко и приятно, совсем не так как во дворце и, уж тем более, в городе. Здесь мы договорились о встрече с Фредом и Уиллом. ';
    way = {
        dpath {'Во дворец', 40 * MINUTE, 'west_gate_outside'};
    }
}: with {
    obj {
        nam = "#trees";
        dsc = 'Высокие стволы {елей} поднимаются до самых небес, ';
        act = 'Высокие стройные деревья, покрытые хвоей. Я читала, что они растут практически по всему Тайранделу. ';
    };
    obj {
        nam = "#forest";
        dsc = 'а чуть дальше начинается густой {лес}. ';
        act = 'Мне нравится гулять там с Таггартом или ребятами, но если я войду туда одна, то обратно не выйду. ';
    };
    obj {
        nam = '#grass';
        dsc = '{Трава} здесь совершенно вытоптана. ';
        act = 'Большая ровная площадка хорошо подходит для активных игр, столь любимых городскими мальчишками. Я тоже непрочь порезвиться с ними. Может силы у меня не так много, зато бегаю я быстрее многих! ';
    };
    obj {
        nam = '#boys';
        dsc = 'Несколько стаек {мальчишек} носятся по полянке. ';
        act = 'Завидую им и с удовольствием присоединилась бы к ним... {#thoughts|Эх, если бы у меня было столько свободного времени...} ';
    };
    obj {
        nam = '#thoughts';
        act = 'Давно бы уже собрала свою счетную машинку!';
    };
    obj {
        nam = '#fred_and_will';
        dsc = '{Фред и Уилл} сидят на корточках у одного из деревьев и что-то рассматривают в траве. ';
        act = function(s)
            if _('boys_dlg').state == 0 then
                walkin('boys_dlg');
            else
                pr [[Мне сегодня совсем некогда с ними играть. ]];
            end;
        end;
    };
}

dlg {
    state = 0;
    nam = 'boys_dlg';
    noinv = true;
    notime = true;
    disp = 'Фред и Уилл';
    enter = [[Фред и Уилл даже не заметили моего приближения. ]];
    phr = {
        {'Привет, ребята!', function(s)
            if s.state == 0 then
                s.state = 1;
                return 'Фред отвлекается от процесса и приветствует меня: "Привет, Асти!" Уилл повторяет за ним: "Привет, Асти!". ';
            else
                return 'Уилл отвечает: "Привет, Асти!"^Фред просто молча машет мне рукой.'
            end;
        end;
        };
        {'Что увидели?', function(s)
            if s.state == 0 then
                s.state = 1;
                return 'Фред отвлекается от процесса и смотрит на меня: "Привет, Асти! Тут жук! Красивый! Смотри!" -- Он показывает пальцем в траву. ^ Я смотрю и вижу переливающегося зеленого жука. Я читала, что он называется "золотистая бронзовка", но до этого видела его только на картинках. Действительно, очень красивый.';
            else
                return 'Фред отвлекается от процесса и смотрит на меня: "Тут жук! Красивый! Смотри!" -- Он показывает пальцем в траву. ^ Я смотрю и вижу переливающегося зеленого жука. Я читала, что он называется "золотистая бронзовка", но до этого видела его только на картинках. Действительно, очень красивый.';
            end;
        end};
        {cond=function(s) return have('trinket') end, '[Отдать колечко] Я принесла то, что обещала.', function(s)
            remove('trinket', me());
            boys_status = 1;
            if s.state == 0 then
                s.state = 1;
                return [[
                    Фред отвлекается от процесса и смотрит на меня: "О! Асти! Привет!". ^
                    Уилл берет серебряное колечко из моих рук и восклицает: "Вау! Асти, где ты взяла его?!"
                ]];
            else
                return [[
                    Уилл берет серебряное колечко из моих рук и восклицает: "Вау! Асти, где ты взяла его?!"
                ]];
            end;
        end, 
            {'Из дома принесла. Только никому не говорите. ', function(s)
                remove(lookup('#fred_and_will', 'forest'), 'forest');
                walkout();
                return 'Уилл кивает: "Класс, спасибо тебе огромное, Асти! Нам этого колечка хватит, чтобы целый месяц в цирк ходить!"^ Радостные, ребята убегают. А мне пора во дворец. ';
            end}
        };
    };
}

cutscene {
    nam = 'ending1';
    disp = 'Утро принцессы Асурьи';
    noinv = true;
    notime = true;
    decor = function(s)
        if dinner_status == 1 then
            pr [[К тому моменту, как [cut я появляюсь]я появляюсь на празднике, в зале остаются лишь редкие гости. Мой отец, едва увидев меня, резким шагом направляется ко мне. ^]];
            pr [[ [cut "Асурья!.."]"Асурья! То, что ты себе позволяешь, уже ни в какие рамки не лезет!" -- он почти кричит на меня, а я могу лишь стоять, виновато опустив голову. ^]];
            pr [[
                [cut Схватив меня за руку]
            ]];
            pr [[Схватив меня за руку, он буквально тащит меня за собой в кабинет. Втолкнув меня внутрь и закрыв дверь, он принялся кричать, уже не сдерживаясь: "Да что ты себе позволяешь, демоница! С кем поведешься от того и наберешься! Якшаешься со всяким сбродом! Разве это подобает наследнице престола?!.." -- отец продолжает ругаться еще очень долго. ^]];
            pr [[
                [cut Я еле сдерживаюсь, чтобы не заплакать ]
            ]];
            pr [[Я еле сдерживаюсь, чтобы не заплакать. Да, я девочка, но я будущая императрица! [cut Я должна быть сильной!]Я должна быть сильной! Все мне так говорят. [cut Я вспомнила, как учил меня Уилл]Я вспомнила, как учил меня Уилл -- стиснуть зубы и молчать. ^]];
            pr [[
                Я молча выслушала бесконечную тираду отца. Наконец, подошло самое интересное... [cut Наказание]Наказание.^
                Вот тут я уже не могла сдержаться и разразилась слезами. На ближайший год вся моя жизнь [cut превращалась в ад]превращалась в ад -- [cut отныне мне нельзя]отныне мне нельзя было общаться ни с кем, кроме моих родственников, личных слуг и придворных. [cut Мне запретили]Мне запретили посещать лаборатории и мастерские, выходить из замка без сопровождения. И кроме того, в моем расписании [cut теперь]теперь вдвое больше уроков этикета. Соответственно, [cut возможности заниматься механикой]возможности заниматься механикой у меня пока тоже нет.^
            ]];
        elseif dinner_status == 2 then
            pr [[
                [cut Я появляюсь]Я появляюсь, когда праздник в самом разгаре и мгновенно [cut привлекаю к себе внимание]привлекаю к себе внимание. Теперь мое опоздание еще долго будут обсуждать все во дворце, но это не самое страшное. [cut Самое страшное]Самое страшное, это разгневанный взгляд отца. ^
                Праздник проходит как обычно -- музыканты играют замысловатые мелодии, гости сидят за столами и вкушают всевозможные яства. Я, как и положено, [cut занимаю место рядом с отцом]занимаю место рядом с отцом. ^
                Полтора часа разговоров о моде, погоде, причинах моего опоздания и других придворных глупостях спустя, празднество наконец-то подходит к концу. ^
                [cut Император поднимается из-за стола] Император поднимается из-за стола и объявляет, что праздник окончен. Гости начинают расходиться, а это значит что скоро меня ждет [cut долгий и тяжелый разговор]долгий и тяжелый разговор в кабинете отца. ^
            ]];
            pr [[
                Едва я вошла, он принялся кричать на меня: "Да что ты себе позволяешь, демоница! С кем поведешься от того и наберешься! Якшаешься со всяким сбродом! Разве это подобает наследнице престола?!.." -- отец продолжает ругаться еще очень долго.^
            ]];
            pr [[
                [cut Я еле сдерживаюсь, чтобы не заплакать ]
            ]];
            pr [[Я еле сдерживалась, чтобы не заплакать. Да, я девочка, но я будущая императрица! [cut Я должна быть сильной!]Я должна быть сильной! Все мне так говорят. [cut Я вспомнила, как учил меня Уилл]Я вспомнила, как учил меня Уилл: стиснуть зубы и молчать. ^]];
            pr [[
                Я молча выслушала бесконечную тираду отца. Наконец, подошло самое интересное... [cut Наказание]Наказание.^
                Вот тут я уже не могла сдержаться и разразилась слезами. На ближайшие три месяца вся моя жизнь [cut превращалась в ад]превращалась в ад -- [cut отныне мне нельзя]отныне мне нельзя было общаться ни с кем, кроме моих родственников, личных слуг и придворных. [cut Мне запретили]Мне запретили посещать лаборатории и мастерские, выходить из замка без сопровождения. И кроме того, в моем расписании [cut теперь]теперь вдвое больше уроков этикета. Соответственно, [cut возможности заниматься механикой]возможности заниматься механикой у меня пока тоже нет.^
            ]];
        elseif dinner_status == 3 then
            pr [[
                Когда [cut я вхожу в зал]я вхожу в зал, многих гостей все еще нет на местах, так что на мое опоздание мало кто обратил внимание... [cut Кроме]Кроме моих родителей... Недовольный взгляд отца обещает неприятный разговор после праздника, но пока я могу [cut "наслаждаться"]"наслаждаться" пиром.^
                Как и большинство праздников во дворце этот заключался в набивании живота изысканными блюдами и "интереснейшими" беседами о моде, погоде и прочих глупостях, о которых мне приходилось из вежливости разговаривать.^
                Когда праздник заканчивается, [cut император поднимается из-за стола]император поднимается из-за стола, чтобы провозгласить это, а я вздыхаю с облегчением. Вскоре большинство гостей расходятся, и отец берет меня за руку и тащит в свой кабинет. ^
                [cut Едва мы вошли]Едва мы вошли, как он принялся отчитывать меня: "Вот скажи мне, доченька, милая, в кого ты такая уродилась?! Почему ты не можешь просто быть как все нормальные благовоспитанные дети..."
                Ругался он долго, но к счастью, не особо обидно -- бывало и хуже. А потом подошло самое интересное... [cut Наказание]Наказание.^
                Я легко отделалась. В ближайший месяц [cut мне предстояло]мне предстояло  двойное количество занятий этикетом и [cut полный запрет]полный запрет покидать замок, для этого ко мне приставили двух слуг, которые будут следить за мной. В остальном же -- все оставалось как прежде. ^
            ]];
        elseif dinner_status == 4 then
            pr [[
                [cut Я вхожу в зал]Я вхожу в зал одной из первых и занимаю [cut свое почетное место]свое почетное место, рядом с императором -- своим отцом. Вскоре [cut начинается обед]начинается обед и мы все приступаем к трапезе после вступительного слова папы. Минут десять [cut он рассказывает]он рассказывает о том, насколько важно это мероприятие и насколько ценна для нас эта возможность собраться, но почему-то почти не упоминает о [cut событиях в Далагаре]событиях в Далагаре -- видимо это не имеет особого значения.^
                Как и большинство праздников во дворце этот заключался в набивании живота изысканными блюдами и "интереснейшими" беседами о моде, погоде и прочих глупостях, о которых мне приходилось из вежливости разговаривать.^
                Когда [cut праздник заканчивается]праздник заканчивается и император поднимается из-за стола, чтобы провозгласить это, я вздыхаю с облегчением и выбегаю из зала -- да, сегодня мне уже [cut не удастся]не удастся позаниматься своими делами и побыть в одиночестве, но теперь хотя бы можно переодеться во что-нибудь поудобнее. ^
            ]];
        end;
        
        pr [[
            [cut Продолжить]
            [code walk('ending2');]
        ]];
    end;
}

cutscene {
    nam = 'ending2';
    disp = 'Утро принцессы Асурьи';
    noinv = true;
    notime = true;
    decor = function(s)
        if widget_status == 0 then
            if dinner_status < 3 then
                pr [[
                    Жизнь медленно тянулась дальше. Вскоре друзья смогли передать мне [cut письмо от Виджета]письмо от Виджета: ^
                    _"Асти, привет! ^
                    Очень плохо, что ты не смогла прийти. 
                    [cut Ты знаешь..."_]Ты знаешь, что нам непросто организовывать для тебя такие дни. ^Впрочем, ты и так достаточно строго наказана. Поговорим, когда твое наказание подойдет к концу. ^^

                    С наилучшими пожеланиями, ^
                    Виджет"_.^
                    [cut Дела плохи]Дела плохи. Вдобавок ко всему, Виджет обиделся на меня. ^
                ]];
            else
                pr [[
                    При первой возможности [cut я заглянула к Виджету в мастерскую]я заглянула к Виджету в мастерскую. Гремлин был как обычно занят своими делами, так что мне пришлось окликнуть его: [cut "Виджет, это я!"]"Виджет, это я!"^
                    Мастер нехотя оглянулся и посмотрел на меня. 
                    Поскольку в мастерской больше никого не было, он [cut называл меня по имени]называл меня по имени: _"А, Асти, привет! Очень плохо, что ты не пришла. [cut Ты знаешь]Ты знаешь, что нам непросто организовывать для тебя место -- приходится столько всего подготовить и часть работ приостановить. Стараешься для тебя..."_ -- Гремлин махнул рукой и вернулся к своим делам. ^
                    [cut Дела плохи]Дела плохи, похоже Виджет обиделся на меня, так что и впрямь неясно, как скоро сможем продолжить занятия. ^
                ]];
            end;
        elseif widget_status == 1 then
            if dinner_status < 3 then
                pr [[
                    Жизнь медленно тянулась дальше. Вскоре друзья смогли передать мне [cut письмо от Виджета]письмо от Виджета: ^
                    _"Асти, привет!^
                    Мы с Флинном слышали, что тебе здорово попало. Будем скучать по тебе. Ты конечно [cut создала нам проблем.."_]создала нам проблем своим опозданием, но это не страшно. Я тут пораскинул мозгами, и твой проект кажется мне весьма интересным. Жду не дождусь, когда сможем продолжить работу над ним.  ^^

                    Ждем твоего возвращения, ^
                    Виджет и Флинн"_.^
                    [cut Гремлин не в обиде]Гремлин не в обиде, что я опоздала, это уже хорошо. Но вот когда я теперь смогу продолжить занятия -- неизвестно. ^
                ]];
            else
                pr [[
                    При первой возможности [cut я заглянула к Виджету в мастерскую]я заглянула к Виджету в мастерскую. Гремлин был как обычно занят своими делами, так что мне пришлось окликнуть его: [cut "Виджет, это я!"]"Виджет, это я!"^
                    Мастер нехотя оглянулся и посмотрел на меня. 
                    Поскольку в мастерской больше никого не было, он [cut называл меня по имени]называл меня по имени: _"А, Асти, привет! Я тут немного занят -- ты тогда [cut немного задержала нас..."_]немного задержала нас, приходится наверстывать. Я теперь даже не знаю, как скоро теперь сможем выделить для тебя место. Но, [cut знаешь..."_]знаешь, пораскинув мозгами, скажу что мне интересен твой проект, так что сделаю все, что в моих силах"_. ^
                    Что же, [cut могло быть и хуже]могло быть и хуже. По-крайней мере Виджет не в обиде из-за моего опоздания. ^
                ]];
            end;
        elseif widget_status == 2 then
            if dinner_status < 3 then
                pr [[
                    Жизнь медленно тянулась дальше. Вскоре друзья смогли передать мне [cut письмо от Виджета]письмо от Виджета: ^
                    _"Асти, привет!^
                    Мы с Флинном будем скучать по тебе. Я тут [cut пораскинул мозгами..."_]пораскинул мозгами и твой проект кажется мне весьма интересным. Жду не дождусь, когда сможем продолжить работу над ним.  ^^

                    С наилучшими пожеланиями, ^
                    Виджет"_.^
                    [cut Да, жаль]Да, жаль что теперь мы не скоро увидимся... И [cut мой проект]мой проект откладывается на продолжительный срок.^
                ]];
            else
                pr [[
                     При первой возможности [cut я заглянула к Виджету в мастерскую]я заглянула к Виджету в мастерскую. Гремлин был как обычно занят своими делами, так что мне пришлось окликнуть его: [cut "Виджет, это я!"]"Виджет, это я!"^
                    Мастер оглянулся и посмотрел на меня. 
                    Поскольку в мастерской больше никого не было, он [cut называл меня по имени]называл меня по имени: _"А, Асти, привет! Рад, что ты зашла. [cut Пораскинув мозгами..."_]Пораскинув мозгами, скажу что мне интересен твой проект, так что если хочешь, можем организовать тебе занятие хоть завтра"_. ^
                    [cut Не раздумывая]Не раздумывая, я соглашаюсь -- самой не терпится посмотреть на свою счетную машинку. ^
                ]];
            end;
        end;

        pr [[
            [cut Продолжить]
            [code walk('ending3');]
        ]];
    end;
}

cutscene {
    nam = 'ending3';
    disp = 'Утро принцессы Асурьи';
    noinv = true;
    notime = true;
    decor = function(s)
        if taggart_status == 0 then
            pr [[
                Затем я узнала и [cut о произошедшем с Таггартом]о произошедшем с Таггартом. Слугам удалось кое-что разузнать о его судьбе. [cut За потерю ключа]За потерю ключа он получил огромный штраф, а [cut кроме того]кроме того, его понизили в звании и перевели в городскую стражу. [cut Сам он]Сам он мне не писал и, скорее всего, общаться со мной больше не будет. ^
                А еще [cut через несколько дней]через несколько дней отец снова вызвал меня к себе. Он узнал про [cut мои занятия алхимией]мои занятия алхимией -- в ходе расследования дела Таггарта мою лабораторию вполне закономерно нашли. [cut После очередной тирады]После очередной тирады он объявил мне, что теперь до самого совершеннолетия я [cut ни на минуту]ни на минуту не останусь без надзора, чтобы даже мысли не возникло заниматься чем-то опасным. Помимо запрета занятий алхимией, это значит, что [cut я больше не смогу]я больше не смогу и встречаться с друзьями вне замка.^
                
            ]];
        elseif taggart_status == 1 then
            if dinner_status < 3 then
                pr [[
                    Затем я получила и [cut письмо от Таггарта]письмо от Таггарта: ^
                    "Асти, привет! ^
                    Жаль, что нескоро увидимся, но ты хоть пиши. Может удастся тебя хоть на денек в город вытащить, а то совсем тяжело тебе. ^^
                    До скорых встреч, ^
                    Таггарт".^
                    [cut Старый друг]Старый друг в порядке, и это не может меня не радовать. 
                ]];
            else
                pr [[
                    Вскоре у меня получилось [cut встретиться с Таггартом]встретиться с Таггартом. Старый друг, как всегда, был [cut рад меня видеть]рад меня видеть. С Таггартом очень интересно гулять по городу -- он знает много красивых мест в самых разных кварталах города и на удивление хорошо ориентируется в хитросплетениях улиц.
                    Мы хорошо пообщались и замечательно провели вечер. ^
                ]];
            end;
        end;

        pr [[
            [cut Продолжить]
            [code walk('ending4');]
        ]];
    end;
}

cutscene {
    nam = 'ending4';
    disp = 'Утро принцессы Асурьи';
    noinv = true;
    notime = true;
    decor = function(s)
        if boys_status == 0 then
            if taggart_status == 0 then
                pr [[
                    Поскольку жизнь моя теперь [cut ограничена дворцом]ограничена дворцом, Уилла и Фреда я с тех пор не видела. Я пыталась [cut выйти на связь с ними]выйти на связь с ними, но это оказалось безуспешно, по-крайней мере с моими весьма ограниченными возможностями. Что же, остается только надеяться, что у них все хорошо. ^
                ]];
            elseif dinner_status < 3 then
                pr [[
                    [cut Встретить Уилла и Фреда]Встретить Уилла и Фреда мне удалось только после того, как срок моего наказания подошел к концу. Ребята уже успели забыть меня. Конечно, [cut зря я напомнила о себе]зря я напомнила о себе, ведь тут же получила прозвище "Асти-врунишка", которое довольно быстро разлетелось по городу. Играть со мной, естественно, никто уже не хотел. [cut Хорошо]Хорошо, что они так и не узнали, кто я на самом деле. ^
                ]];
            else
                pr [[Вскоре мне удалось [cut встретиться с Фредом и Уиллом]встретиться с Фредом и Уиллом. К сожалению, цирк, куда так хотели попасть мальчишки уже уехал. Конечно, я тут же получила [cut прозвище]прозвище "Асти-врунишка", которое довольно быстро разлетелось по городу. Играть со мной, естественно, никто уже не хотел. [cut Хорошо]Хорошо, что они так и не узнали, кто я на самом деле. ^ ]];
            end;
        elseif boys_status == 1 then
            if taggart_status == 0 then
                pr [[
                    Поскольку жизнь моя теперь [cut ограничена дворцом]ограничена дворцом, Уилла и Фреда я с тех пор не видела. Я пыталась [cut выйти на связь с ними]выйти на связь с ними, но это оказалось безуспешно, по-крайней мере с моими весьма ограниченными возможностями. [cut Однако]Однако, это получилось у них. Однажды, я получила [cut письмо]письмо, написанное мальчишками:^ 
                    _"Асти! Это мы, Фред и Уилл тебе пишем. Мы тебя помним и скучаем. У нас все хорошо. [cut Возвращайся..."_]Возвращайся"_. ^
                    Я искренне обрадовалась, что у моих друзей все хорошо и отправила им [cut ответ]ответ, в котором написала, что тоже скучаю по ним и объяснила, почему не могу с ними больше играть.^
                ]];
            elseif dinner_status < 3 then
                pr [[ 
                    [cut Встретить Уилла и Фреда]Встретить Уилла и Фреда мне удалось только после того, как срок моего наказания подошел к концу. [cut Ребята]Ребята были очень рады видеть меня. [cut Они рассказали]Они рассказали о том, как хорошо они тогда развлеклись, [cut сказали]сказали, что часть оставшихся денег сохранили на будущее. [cut Потом]Потом мы долго играли и болтали о всяком. [cut Я рассказала]Я рассказала им о своем проекте счетной машинки, [cut и Фред]и Фред, кажется, заинтересовался этим -- он задавал много вопросов и сказал, что хочет тоже собирать всякие интересные вещи. ^
                ]];
            else
                pr [[
                    Вскоре мне удалось [cut встретиться с Фредом и Уиллом]встретиться с Фредом и Уиллом. [cut Ребята]Ребята были очень рады видеть меня. Они рассказали о том, как классно было в цирке. Выразили сожаление, что я не смогла сходить туда вместе с ними. [cut Рассказали]Рассказали, что часть оставшихся денег хотят сохранить на будущее. Потом мы долго играли и болтали о всяком. [cut Я рассказала]Я рассказала им о своем проекте счетной машинки, [cut и Фред]и Фред, кажется, заинтересовался этим -- он задавал много вопросов и сказал, что хочет тоже собирать всякие интересные вещи. ^ 
                ]];
            end;
        end;

        pr [[^
            [cut КОНЕЦ]
            [cut Вам же сказали -- конец]
            [cut Точно конец]
            [cut Повторю еще раз -- КОНЕЦ ИГРЫ]
            [cut Что вы хотите увидеть?]
            [cut Не тычь в меня этой штуковиной!]
            [cut Это как в игре про красную кнопку]
            [cut Да-да, точно как там]
            [cut Не надо больше никуда нажимать]
            [cut Серьезно, запускайте следующую игру]
            [cut Чего вы ждете?]
            [cut Вы думаете, что игра еще не окончена?]
            [cut Не думайте, закрывайте игру и идите заниматься своими делами]
            [cut Зачем вам все это?]
            [cut Хотели?]
            [cut Получайте]
            [cut КОНЕЦ. На этот раз точно]
            [cut Ой, всё]
            [cut Остается только сесть и заплакать]
            [cut Не верите?]
            [cut Проверяйте]
            КОНЕЦ (Я же говорил).
        ]];
    end;
}

function init(load)
    if not load then
        lifeon('watch');
        take('watch');
        take('task_list');
    end;
end;