import sys, os, fcntl, signal
from PyQt5 import QtWidgets, QtCore
from devices import get_storage_devices
from forms.mainwindow import MainWindow
from pics import pics

devices = get_storage_devices(True, 'disk')


#if not os.access('/dev/{}', os.R_OK) or not os.access('/dev/{}', os.W_OK):
#    if QtWidgets.QMessageBox.question('Access denied', 'Unable to get access to disk drives')


app = QtWidgets.QApplication(sys.argv)


def handle_signal_wakeup():
    notifier.setEnabled(False)
    read_fd = notifier.socket()
    try:
        os.read(read_fd, 1)
    except OSError:
        print("Failed to read wakeup fd.")
    notifier.setEnabled(True)


def destroy(a, b):
    form.clean()
    app.exit(128 + a)


read_fd, write_fd = os.pipe()
for fd in (read_fd, write_fd):
    flags = fcntl.fcntl(fd, fcntl.F_GETFL)
    fcntl.fcntl(fd, fcntl.F_SETFL, flags | os.O_NONBLOCK)


notifier = QtCore.QSocketNotifier(read_fd, QtCore.QSocketNotifier.Read)
notifier.activated.connect(handle_signal_wakeup)
orig_wakeup_fd = signal.set_wakeup_fd(write_fd)
signal.signal(signal.SIGTERM, destroy)
signal.signal(signal.SIGINT, destroy)


form = MainWindow()
form.show()
rval = app.exec()
form.clean()
sys.exit(rval)
