import subprocess, json


class MountException(Exception):
    pass


def mount(source, target, fs, options=''):
    NotImplementedError('Not yet')


def is_mounted(device):
    proc = subprocess.Popen(['findmnt', '-J', device], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    result = proc.wait()
    if result == 1:
        return False
    output = proc.stdout.read().decode('utf')
    if output:
        output = json.loads(output)
        return len(output['filesystems']) > 0
    else:
        return False


def unmount(device):
    proc = subprocess.Popen(['umount', device], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    if proc.wait() != 0:
        raise MountException(proc.stderr.read().decode('utf8'))
