from PyQt5.QtCore import QRect, QItemSelectionModel
from PyQt5.QtWidgets import QDialog
from PyQt5 import QtCore

from gui.about import AboutWidget
from gui.main_settings import MainSettingsWidget
from .ui.settings import Ui_Form


class SettingsForm(Ui_Form, QDialog):
    PAGES = [
        'main_settings',
        'about'
    ]

    def __init__(self, config, index=0):
        super().__init__()
        self.config = config
        self.setupUi(self)
        self.cancel_button.clicked.connect(self.on_cancel)
        self.ok_button.clicked.connect(self.on_ok)
        self.apply_button.clicked.connect(self.on_apply)
        for i in range(len(self.PAGES)):
            self.group_list.item(i).setData(QtCore.Qt.UserRole, self.PAGES[i])
        self.group_list.currentItemChanged.connect(self.on_page_change)
        self.tabs = {
            'main_settings': MainSettingsWidget(config),
            'about': AboutWidget()
        }
        self.group_list.setCurrentRow(index)

    def on_page_change(self, current, _):
        print(current.data(QtCore.Qt.UserRole))
        self.scrollArea.takeWidget()
        tab = self.tabs[current.data(QtCore.Qt.UserRole)]
        self.scrollArea.setWidget(tab)

    def on_cancel(self):
        self.reject()

    def on_ok(self):
        self.on_apply()
        self.accept()

    def on_apply(self):
        self.tabs['main_settings'].update_config()
        self.config.save()
