import sys, traceback


class EventDispatcher:
    def __init__(self, *event_names):
        self._events = {}
        self._listname = 0
        for n in event_names:
            self._events[n] = {}

    def add_handler(self, name, listener, listener_name=None):
        # TODO add proper checks and specific exception if event is not supported
        if not listener_name:
            listener_name = '__auto__name__{}'.format(self._listname)
            self._listname += 1
        self._events[name][listener_name] = listener

    def remove_handler(self, name, listener_name=None):
        # TODO add proper checks and specific exception if event is not supported
        if listener_name:
            del self._events[name][listener_name]
        else:
            self._events[name].clear()

    def dispatch(self, name, *args, **kwargs):
        # TODO add special exceptions for StopPropagation and PreventDefault
        for e in self._events[name].values():
            try:
                e(*args, **kwargs)
            except Exception:
                sys.stderr.write(traceback.format_exc())
