from config.config import ConfigFile
from gui.tray import TrayManager
from gui.dropper import KCDEmuDropperWidget
from cdemu import CDEmu
from PyQt5 import QtWidgets, QtCore
import sys, os, fcntl, signal
from dbus.mainloop.pyqt5 import DBusQtMainLoop

# noinspection PyUnresolvedReferences
import pics

DBusQtMainLoop(set_as_default=True)

app = QtWidgets.QApplication(sys.argv)
app.setQuitOnLastWindowClosed(False)


def handle_signal_wakeup():
    notifier.setEnabled(False)
    read_fd = notifier.socket()
    try:
        os.read(read_fd, 1)
    except OSError:
        print("Failed to read wakeup fd.")
    notifier.setEnabled(True)


def destroy(a, b):
    app.exit(128 + a)


read_fd, write_fd = os.pipe()
for fd in (read_fd, write_fd):
    flags = fcntl.fcntl(fd, fcntl.F_GETFL)
    fcntl.fcntl(fd, fcntl.F_SETFL, flags | os.O_NONBLOCK)

notifier = QtCore.QSocketNotifier(read_fd, QtCore.QSocketNotifier.Read)
notifier.activated.connect(handle_signal_wakeup)
orig_wakeup_fd = signal.set_wakeup_fd(write_fd)
signal.signal(signal.SIGTERM, destroy)
signal.signal(signal.SIGINT, destroy)

config_path = os.environ.get('XDG_CONFIG_HOME', default=os.path.expanduser('~/.config/'))
os.makedirs(os.path.join(config_path, 'silvertools'), exist_ok=True)

config = ConfigFile(os.path.join(config_path, 'silvertools', 'kcdemu_config.cfg'))

cdemu = CDEmu(os.path.join(config_path, 'silvertools', 'kcdemu_state.cfg'), config)
tm = TrayManager(cdemu, config, KCDEmuDropperWidget(cdemu, config))
sys.exit(app.exec())
