#include <time.inc>

var map[256][256]
var openlist[65536 * 8]
var opensize = 1;
var closedlist[256][256][2]

next (x, y, d, x0, y0) {
    var i
    if (x < 0 || y < 0 || x > 255 || y > 255 || closedlist[x][y][0] > -2) return;
    
    for (i = 0; i < opensize; i++) {
        if (openlist[i << 3] == x && openlist[(i << 3) + 1] == y) {
            if (openlist[(i << 3) + 2] > d) {
                openlist[(i << 3) + 2] = d;
                openlist[(i << 3) + 4] = d + openlist[(i << 3) + 3];
                openlist[(i << 3) + 5] = x0;
                openlist[(i << 3) + 6] = y0;
            }
            return;
        }
    }

    var dh = 255 - x;
    if (255 - y > dh) dh = 255 - y;
    //dh /= 2;

    if (map[x][y] == 1) {
        closedlist[x][y][0] = x0;
        closedlist[x][y][1] = y0;
        return;
    }

    opensize++;

    openlist[(opensize - 1) << 3] = x;
    openlist[((opensize - 1) << 3) + 1] = y;
    openlist[((opensize - 1) << 3) + 2] = d;
    openlist[((opensize - 1) << 3) + 3] = dh;
    openlist[((opensize - 1) << 3) + 4] = d + dh;
    openlist[((opensize - 1) << 3) + 5] = x0;
    openlist[((opensize - 1) << 3) + 6] = y0;
}

@start () {
    var i, j, k
    for (i = 0; i < 256; i++) {
        for (j = 0; j < 256; j++) {
            map[i][j] = 0
            
            for (k = 0; k < 2; k++) {
                closedlist[i][j][k] = -2
            }
        }
    }
    
    for (i = 1; i < 256; i++)
        map[i][254] = 1
    
    openlist[0] = 0
    openlist[1] = 0
    openlist[2] = 0
    openlist[3] = 256
    openlist[4] = 256
    openlist[5] = -1
    openlist[6] = -1
    
    var t = tickcount();
    
    while (opensize > 0) {
        var itemindex = 0
        
        for (i = 0; i < opensize; i++) {
            if (openlist[(i << 3) + 4] < openlist[(itemindex << 3) + 4] || !openlist[(itemindex << 3) + 3]) {
                itemindex = i;

                if (!openlist[(itemindex << 3) + 3]) break;
            }
        }
        
        closedlist[openlist[(itemindex << 3)]][openlist[(itemindex << 3) + 1]][0] = openlist[(itemindex << 3) + 5];
        closedlist[openlist[(itemindex << 3)]][openlist[(itemindex << 3) + 1]][1] = openlist[(itemindex << 3) + 6];
        
        if (!openlist[(itemindex << 3) + 3]) break;

        var x = openlist[(itemindex << 3)];
        var y = openlist[(itemindex << 3) + 1];
        var d = openlist[(itemindex << 3) + 2] + 1;

        for (i = 0; i < 7; i++)
            openlist[(itemindex << 3) + i] = openlist[((opensize - 1) << 3) + i];

        opensize--;
        next(x - 1, y - 1, d, x, y);
        next(x, y - 1, d, x, y);
        next(x + 1, y - 1, d, x, y);
        next(x + 1, y, d, x, y);
        next(x + 1, y + 1, d, x, y);
        next(x, y + 1, d, x, y);
        next(x - 1, y + 1, d, x, y);
        next(x - 1, y, d, x, y);
    }
    
    printf("%d\n", tickcount() - t);
    /*
    var cx = 255;
    var cy = 255;
    
    while (cx && cy) {
        printf("%d %d\n", cx, cy);
        cx = closedlist[cx][cy][0];
        cy = closedlist[cx][cy][1];
    }*/
}
