local map = {};
local openlist = {};
local opensize = 1;
local closedlist = {};

for i = 1, 256 do
    map[i] = {};
    closedlist[i] = {};
    for j = 1, 256 do
        map[i][j] = 0;
        closedlist[i][j] = {-2, -2};
    end;
end;

function next(x, y, d, x0, y0)
    local i;
    if (x < 1 or y < 1 or x > 256 or y > 256 or closedlist[x][y][1] > -2) then return; end;

    for i = 1, opensize do
        if (openlist[i][1] == x and openlist[i][2] == y) then
            if (openlist[i][3] > d) then
                openlist[i][3] = d;
                openlist[i][5] = d + openlist[i][4];
                openlist[i][6] = x0;
                openlist[i][7] = y0;
            end;
            return;
        end;
    end;

    local dh = 256 - x;
    if (256 - y > dh) then dh = 255 - y; end;
    --dh = dh / 2;

    if (map[x][y] == 1) then
        closedlist[x][y][1] = x0;
        closedlist[x][y][2] = y0;
        return;
    end;

    opensize = opensize + 1;
    openlist[opensize] = {x, y, d, dh, d + dh, x0, y0};
end;

function main()
    for i = 2, 256 do
        map[i][255] = 1;
    end;
    
    openlist[1] = {1, 1, 0, 256, 256, -1, -1};
    local x = os.clock()
    while opensize > 0 do
        local itemindex = 1;
        for i = 1, opensize do
            if (openlist[i][5] < openlist[itemindex][5] or not openlist[itemindex][4]) then
                itemindex = i;

                if (not openlist[itemindex][4]) then break; end;
            end;
        end;
        
        closedlist[openlist[itemindex][1]][openlist[itemindex][2]][1] = openlist[itemindex][6];
        closedlist[openlist[itemindex][1]][openlist[itemindex][2]][2] = openlist[itemindex][7];
        
        if (not openlist[itemindex][4]) then break; end;

        local x = openlist[itemindex][1];
        local y = openlist[itemindex][2];
        local d = openlist[itemindex][3] + 1;

        openlist[itemindex] = openlist[opensize];

        opensize = opensize - 1;
        next(x - 1, y - 1, d, x, y);
        next(x, y - 1, d, x, y);
        next(x + 1, y - 1, d, x, y);
        next(x + 1, y, d, x, y);
        next(x + 1, y + 1, d, x, y);
        next(x, y + 1, d, x, y);
        next(x - 1, y + 1, d, x, y);
        next(x - 1, y, d, x, y);
        
        --for i = 1, opensize do
        --    print(openlist[i][1], openlist[i][2], openlist[i][3], openlist[i][4], openlist[i][5], openlist[i][6], openlist[i][7]);
        --end;
        --io.read();
    end;
    print(os.clock() - x)
    
    --[[ Print the path
    local current = {256, 256};
    while current[1] ~= 1 or current[2] ~= 1 do
        print(current[1], current[2]);
        current = closedlist[current[1] ][current[2] ];
    end;]]
end;

main();

