//
// Created by silverwing on 4/19/25.
//
#include <stdio.h>
#ifdef WIN32
#include <windows.h>
#define CLOCK_REALTIME 0
struct timespec {
    int tv_sec;
    int tv_nsec;
};

void clock_gettime(int any, struct timespec * time) {
    int tmsec = GetTickCount();
    time->tv_sec = tmsec / 1000;
    time->tv_nsec = tmsec * 1000000;
}

#elif
#include <time.h>
#endif
#include "stdlib.h"
#include <memory.h>

int map[256][256];
int *openlist;
int openalloc = 1024; //Allocate once and for all
int opensize = 1;
int closedlist[256][256][2];

void next(int x, int y, int d, int x0, int y0) {
    int i;
    if (x < 0 || y < 0 || x > 255 || y > 255 || closedlist[x][y][0] > -2) return;

    for (i = 0; i < opensize; i++) {
        if (openlist[i << 3] == x && openlist[(i << 3) + 1] == y) {
            if (openlist[(i << 3) + 2] > d) {
                openlist[(i << 3) + 2] = d;
                openlist[(i << 3) + 4] = d + openlist[(i << 3) + 3];
                openlist[(i << 3) + 5] = x0;
                openlist[(i << 3) + 6] = y0;
            }
            return;
        }
    }

    int dh = 255 - x;
    if (255 - y > dh) dh = 255 - y;
    //dh /= 2;

    if (map[x][y] == 1) {
        closedlist[x][y][0] = x0;
        closedlist[x][y][1] = y0;
        return;
    }

    opensize++;
    if (opensize >= openalloc) {
        openalloc *= 2;
        openlist = realloc(openlist, sizeof(int) * 8 * openalloc);
    }

    openlist[(opensize - 1) << 3] = x;
    openlist[((opensize - 1) << 3) + 1] = y;
    openlist[((opensize - 1) << 3) + 2] = d;
    openlist[((opensize - 1) << 3) + 3] = dh;
    openlist[((opensize - 1) << 3) + 4] = d + dh;
    openlist[((opensize - 1) << 3) + 5] = x0;
    openlist[((opensize - 1) << 3) + 6] = y0;
}

int main(int argc, char *argv[]) {
    struct timespec time1;
    struct timespec time2;
    int i, j, k;

    memset(map, 0, 256 * 256 * sizeof(int));

    for (i = 1; i < 256; i++)
        map[i][254] = 1;

    openlist = malloc(sizeof(int) * 8 * openalloc);
    openlist[0] = 0; //current x coordinate
    openlist[1] = 0; //current y coordinate
    openlist[2] = 0; //current known distance
    openlist[3] = 256; //heuristic distance
    openlist[4] = 256; //full distance
    openlist[5] = -1; //previous cell coordinate
    openlist[6] = -1; //previous cell coordinate

    for (i = 0; i < 256; i++)
        for (j = 0; j < 256; j++)
            for (k = 0; k < 2; k++)
                closedlist[i][j][k] = -2;

    FILE * file = fopen("results.log", "w");

    clock_gettime(CLOCK_REALTIME, &time1);

    while (opensize > 0) {
        int itemindex = 0;
        for (i = 0; i < opensize; i++) {
            if (openlist[(i << 3) + 4] < openlist[(itemindex << 3) + 4] || !openlist[(itemindex << 3) + 3]) {
                itemindex = i;

                if (!openlist[(itemindex << 3) + 3]) break;
            }
        }

        closedlist[openlist[(itemindex << 3)]][openlist[(itemindex << 3) + 1]][0] = openlist[(itemindex << 3) + 5];
        closedlist[openlist[(itemindex << 3)]][openlist[(itemindex << 3) + 1]][1] = openlist[(itemindex << 3) + 6];
        
        if (!openlist[(itemindex << 3) + 3]) break;

        int x = openlist[(itemindex << 3)];
        int y = openlist[(itemindex << 3) + 1];
        int d = openlist[(itemindex << 3) + 2] + 1;

        for (i = 0; i < 7; i++)
            openlist[(itemindex << 3) + i] = openlist[((opensize - 1) << 3) + i];

        opensize--;
        next(x - 1, y - 1, d, x, y);
        next(x, y - 1, d, x, y);
        next(x + 1, y - 1, d, x, y);
        next(x + 1, y, d, x, y);
        next(x + 1, y + 1, d, x, y);
        next(x, y + 1, d, x, y);
        next(x - 1, y + 1, d, x, y);
        next(x - 1, y, d, x, y);
    }
    
    clock_gettime(CLOCK_REALTIME, &time2);
    
    int time1_ms = time1.tv_nsec / 1000000 + time1.tv_sec * 1000;
    int time2_ms = time2.tv_nsec / 1000000 + time2.tv_sec * 1000;
    
    printf("%i\n", time2_ms - time1_ms);
    fprintf(file, "%i\n", time2_ms - time1_ms);
    fclose(file);

    free(openlist);
    /*
    int cx = 255;
    int cy = 255;
    
    while (cx && cy) {
        printf("%i %i\n", cx, cy);
        cx = closedlist[cx][cy][0];
        cy = closedlist[cx][cy][1];
    }*/
    
    return 0;
}
